/*
	This script calls the filter plugin to do the resizing work
*/

/*
 <javascriptresource>
 <name>Resize Magic...</name>
 <about>$$$/JavaScripts/ResizeMagic/About=Resize Magic^r^rCopyright 2009 FSoft srl. All rights reserved.^r^rA plugin to resize images with a high-quality algorithm.</about>
 <enableinfo>!((PSHOP_ImageMode!=RGBMode)||PSHOP_HasLayerMask||PSHOP_HasSelectionMask)</enableinfo>
 <eventid>cdab2671-0a32-46d4-8d54-ac89faf7d696</eventid>
 <terminology><![CDATA[<< /Version 1
                       /Events <<
                          /cdab2671-0a32-46d4-8d54-ac89faf7d696 [(Resize Magic)  <<
                            /width [(Width) /typeInteger]
                            /lenght [(Lenght) /typeInteger]
                            /sharpness [(Sharpness) /sharpnessValue]
                           >>]
                        >>
                       /Enums <<
						 /sharpnessValue <<
                           /shrpSmoother (Smoother)
                           /shrpNormal (Normal)
                           /shrpSharper (Sharper)
                         >>
						>>
                      >> ]]></terminology>
 </javascriptresource>
*/

#target photoshop

// --------------------------------------
// the dialogs resources
// --------------------------------------

// main window
var uiRM = "dialog{text:'Resize Magic',bounds:[100,100,470,400], \
			undefined:StaticText{bounds:[20,20,260,40] , text:'This copy is registered to:' ,properties:{scrolling:false,multiline:false}}, \
			stRegistrationName:StaticText{bounds:[20,42,340,59] , text:'Registration name' ,properties:{scrolling:false,multiline:false}}, \
			btnRegister:Button{bounds:[270,20,352,42] , text:'Register' }, \
																																		\
			undefined:Panel{bounds:[20,70,352,70] , text:'' ,properties:{borderStyle:'etched' }}, \
																																		\
			pnlOriginalSize:Panel{bounds:[20,90,195,185] , text:'Original Size' ,properties:{borderStyle:'etched' }, \
				undefined:StaticText{bounds:[15,20,60,37] , text:'Width:' ,properties:{scrolling:false,multiline:false}}, \
				undefined:StaticText{bounds:[15,50,60,67] , text:'Height:' ,properties:{scrolling:false,multiline:false}}, \
				stOriginalWidth:StaticText{bounds:[80,20,160,40] , text:'8500' ,properties:{scrolling:false,multiline:false}}, \
				stOriginalHeight:StaticText{bounds:[80,50,160,70] , text:'2000' ,properties:{scrolling:false,multiline:false}} \
			}, \
			pnlNewSize:Panel{bounds:[20,190,195,285] , text:'New Size' ,properties:{borderStyle:'etched' }, \
				undefined:StaticText{bounds:[15,20,60,37] , text:'Width:' ,properties:{scrolling:false,multiline:false}}, \
				undefined:StaticText{bounds:[15,50,60,67] , text:'Height:' ,properties:{scrolling:false,multiline:false}}, \
				txtWidth:EditText{bounds:[80,20,150,40] , text:'' ,properties:{multiline:false,noecho:false,readonly:false}}, \
				txtHeight:EditText{bounds:[80,50,150,70] , text:'' ,properties:{multiline:false,noecho:false,readonly:false}} \
			}, \
			btnOK:Button{bounds:[270,90,352,112] , text:'OK' }, \
			btnCancel:Button{bounds:[270,120,352,142] , text:'Cancel' }, \
																										\
			pnlImageQuality:Panel{bounds:[210,190,352,285] , text:'Image quality' ,properties:{borderStyle:'etched' }, \
				optSmoother:RadioButton{bounds:[20,12,121,37] , text:'Smoother' }, \
				optNormal:RadioButton{bounds:[20,34,121,59] , text:'Normal' }, \
				optSharper:RadioButton{bounds:[20,56,121,81] , text:'Sharper' } \
			} \
		}";

// registration window
var uiREG = "dialog{text:'Register Resize Magic',bounds:[100,100,860,252], \
			undefined:StaticText{bounds:[20,20,740,40] , text:'Visit www.fsoft.it/imaging to register Resize Magic.' ,properties:{scrolling:false,multiline:false}}, \
			undefined:StaticText{bounds:[20,40,740,60] , text:'You will receive a two-line registration code: enter it below and press OK to unlock the software.' ,properties:{scrolling:false,multiline:false}}, \
			undefined:StaticText{bounds:[20,80,80,100] , text:'Line 1:' ,properties:{scrolling:false,multiline:false}}, \
			txtKey1:EditText{bounds:[80,80,640,100] , text:'' ,properties:{multiline:false,noecho:false,readonly:false}}, \
			undefined:StaticText{bounds:[20,110,80,130] , text:'Line 2:' ,properties:{scrolling:false,multiline:false}}, \
			txtKey2:EditText{bounds:[80,110,640,130] , text:'' ,properties:{multiline:false,noecho:false,readonly:false}}, \
			btnOK:Button{bounds:[660,80,740,102] , text:'OK' }, \
			btnCancel:Button{bounds:[660,110,740,132] , text:'Cancel' }, \
		}";

// --------------------------------------
// UI event handlers
// --------------------------------------

function dlgMain_onShow() {
  this.pnlNewSize.txtWidth.active = true;
}

function txtWidth_onChanging() {
	changedDimension = "w";
	var orgW = Number( this.parent.parent.pnlOriginalSize.stOriginalWidth.text );
	var orgH = Number( this.parent.parent.pnlOriginalSize.stOriginalHeight.text );
	var w = Number( this.text );
	var s = w.toString(10);
	if( this.text == 0 ) this.parent.txtHeight.text = "";
	if( s.length <= 1 ) return;	// do not handle very short text
	if( this.text == s ) {
		this.parent.txtHeight.text = Math.round( w*orgH/orgW );
	}
	else {
		this.parent.txtHeight.text = "";
	}
}

function txtHeight_onChanging() {
	changedDimension = "h";
	var orgW = Number( this.parent.parent.pnlOriginalSize.stOriginalWidth.text );
	var orgH = Number( this.parent.parent.pnlOriginalSize.stOriginalHeight.text );
	var h = Number( this.text );
	var s = h.toString(10);
	if( this.text == 0 ) this.parent.txtWidth.text = "";
	if( s.length <= 1 ) return;	// do not handle very short text
	if( this.text == s ) {
		this.parent.txtWidth.text = Math.round( h*orgW/orgH );
	}
	else {
		this.parent.txtWidth.text = "";
	}
}

function btnOK_onClick() {
	// check input data
	var sw = this.parent.pnlNewSize.txtWidth.text;
	var sh = this.parent.pnlNewSize.txtHeight.text;
	
	if( sw == "" ) {
		MsgErr( "The new width is missing" );
		this.parent.pnlNewSize.txtWidth.active = true;
		return;
	}
	if( sw != Number(sw) ) {
		MsgErr( "The new width is not correct" );
		this.parent.pnlNewSize.txtWidth.active = true;
		return;
	}
	if( sh == "" ) {
		MsgErr( "The new height is missing" );
		this.parent.pnlNewSize.txtHeight.active = true;
		return;
	}
	if( sh != Number(sh) ) {
		MsgErr( "The new height is not correct" );
		this.parent.pnlNewSize.txtHeight.active = true;
		return;
	}

	this.parent.close(1);
}

function btnRegister_onClick() {
	var dlgReg = new Window( uiREG );
	dlgReg.txtKey1.active = true;
	dlgReg.btnOK.onClick = btnOK_REG_onClick;
	var r = dlgReg.show();
	if( r != 1 ) return
	
}

// handler for the Register dialog
function btnOK_REG_onClick() {
	// check input data
	var key1 = this.parent.txtKey1.text;
	var key2 = this.parent.txtKey2.text;
	if( key1 == "" ) {
		MsgErr( "Line 1 is missing" );
		this.parent.txtKey1.active = true;
		return;
	}
	if( key2 == "" ) {
		MsgErr( "Line 2 is missing" );
		this.parent.txtKey2.active = true;
		return;
	}
	
	// send the keys to the plugin
	var idPlugin = app.stringIDToTypeID( uniqueString);
	var rad = ExecuteCommandSetRegistrationKeys( idPlugin, key1, key2 );
	var keyRes = GetResultStatus( rad );
	if( keyRes == enumWrongRegistrationKey ) {
		MsgErr( "The registration key is not correct" );
		return;
	}
	
	this.parent.close(1);
}

// --------------------------------------
// constants
// --------------------------------------

// Resize Magic unique string
var uniqueString = "5980c640-f167-11dd-ba2f-0800200c9a66"

// the version of the script. It should match with the version of the plugin.
var scriptVersion = "2.01";

// remembers the dimension that was changed by the user
// "w" = width, "h" = height, "" = nothing changed
// used to decide what parameter to save: saving both would cause problems if the next image did not have the same aspect ratio
var changedDimension = "";

// the dimension(s) read from the parameters ( previos run or we are in an action)
// "w" = width, "h" = height, "" = no dimensions read, "b" = both
var dimensionFromParameters = "";

// the action known by the plugin
var keyAction = "Act ";
var typeAction = "TAct";
var enumRMFirstStep = "Stp1";
var enumRMSecondStep = "Stp2";
var enumRMClear = "Clr ";
var enumRMGetRegistrationName = "Grnm";
var enumRMSetRegistrationKey = "Srgk";
var enumRMGetVersion = "GVrs";

// sharpness enumeration
var keyRMSharpness = "Ksrp"
var typeRMSharpness = "TShr"
var enumShrpSmoother = "Smth"
var enumShrpNormal = "Nrml"
var enumShrpSharper = "Srpr"

// result values passed back to this script
var keyResult = "Rslt";
var typeResult = "TRsl";
var enumOK = "OK  ";
var enumWrongRegistrationKey = "WrRK";

var keyRegistrationName = "Krnm";
var keyRegistrationKey1 = "Rgk1";
var keyRegistrationKey2 = "Rgk2";
var keyRMVersion = "KVrs";

// parameters of the script user interface
// sharpness uses the same values used fot the plugin calls
var keyRMWidth = "RMWt";
var keyRMHeight = "RMHt";
var scriptParametersUUID = "bf0b726d-490e-420c-a516-023be4400dd0";
var actionMessage = "Resize Magic action settings";

// return value to Photoshop
var returnValue = "OK"

// --------------------------------------
// functions
// --------------------------------------

// show an error message
function MsgErr( msg ) {
	alert( msg, "Resize Magic" );
}

// send an action to the plugin, without parameters
// idEnumValue is the action requested
function ExecuteCommand( idPlugin, idEnumValue )  {
	// prepare the command
	var ad = new ActionDescriptor();
	var idAction = charIDToTypeID( keyAction );
	var idEnumType = charIDToTypeID( typeAction );
//	var idEnumValue = charIDToTypeID( enumRMGetRegistrationName );
	ad.putEnumerated( idAction, idEnumType, idEnumValue );
	// execute it
	var rad = executeAction( idPlugin, ad, DialogModes.NO );
	return rad;
}

// send an action to the plugin, with a sharpness parameter
// idEnumValue is the action requested
// idShrpParameter is the sharpness value
function ExecuteCommandSetSharpness( idPlugin, idEnumValue, idShrpParameter )  {
	// prepare the command
	var ad = new ActionDescriptor();
	var idAction = charIDToTypeID( keyAction );
	var idEnumType = charIDToTypeID( typeAction );
	ad.putEnumerated( idAction, idEnumType, idEnumValue );
	
	idAction = charIDToTypeID( keyRMSharpness );
	idEnumType = charIDToTypeID( typeRMSharpness );
	ad.putEnumerated( idAction, idEnumType, idShrpParameter );
	
	// execute it
	var rad = executeAction( idPlugin, ad, DialogModes.NO );
	return rad;
}

// send an action to the plugin, with the two registration keys
function ExecuteCommandSetRegistrationKeys( idPlugin, key1, key2 )  {
	// prepare the command
	var ad = new ActionDescriptor();
	var idAction = charIDToTypeID( keyAction );
	var idEnumType = charIDToTypeID( typeAction );
	var idEnumValue = charIDToTypeID( enumRMSetRegistrationKey );
	ad.putEnumerated( idAction, idEnumType, idEnumValue );
	
	// add the parameters
	idAction = charIDToTypeID( keyRegistrationKey1 );
	ad.putString( idAction, key1 );
	idAction = charIDToTypeID( keyRegistrationKey2 );
	ad.putString( idAction, key2 );
	
	// execute it
	var rad = executeAction( idPlugin, ad, DialogModes.NO );
	return rad;
}

// get the return status as a string key
// return "" if the result is not found
function GetResultStatus( rad ) {
	var idResult = charIDToTypeID( keyResult );
	var keyRes;
	if( rad.hasKey(idResult) ) {
		var res = rad.getEnumerationValue( idResult );
		keyRes = typeIDToCharID( res );
	}
	else {
		keyRes = "";
	}
	return keyRes;
}

// check the current image
// return true if it is OK
// show an error message and return false if the image cannot be handled
function CheckCurrentImage() {
	var curDoc = app.activeDocument;
	
	if( curDoc.bitsPerChannel != BitsPerChannelType.EIGHT ) {
		MsgErr( "Resize Magic can only handle images with 8 bits per channel" );
		return false;
	}
	if( curDoc.layers.length != 1 ) {
		MsgErr( "Resize Magic cannot handle images with more than one layer" );
		return false;
	}
	if( curDoc.mode != DocumentMode.RGB ) {
		MsgErr( "Resize Magic can only handle RGB images" );
		return false;
	}

	return true;
}

// create an actiondescriptor contining the parameters to be saved
function CreateSaveSettingsActionDescriptor( w, h, idShrpParameter ) {
	var ad = new ActionDescriptor;
	var idW = charIDToTypeID( keyRMWidth );
	var idH = charIDToTypeID( keyRMHeight );
	var idShrp = charIDToTypeID( keyRMSharpness );
	var idEnumType = charIDToTypeID( typeRMSharpness );
	
	var saveThisDimension;
	saveThisDimension = false;
	if( changedDimension == "w" )
		saveThisDimension = true;
	if( changedDimension == ""  && (dimensionFromParameters == "w" || dimensionFromParameters == "b")  )
		saveThisDimension = true;
	if( saveThisDimension) ad.putInteger( idW, w );

	saveThisDimension = false;
	if( changedDimension == "h" )
		saveThisDimension = true;
	if( changedDimension == ""  && dimensionFromParameters == "h"  )
		saveThisDimension = true;
	if( saveThisDimension )	ad.putInteger( idH, h );

	ad.putEnumerated( idShrp, idEnumType, idShrpParameter );
	
	ad.putString( app.charIDToTypeID( 'Msge' ), actionMessage );

	return ad;
}

// save the parameter values
function SaveParameters( w, h, idShrpParameter ) {
	app.putCustomOptions(scriptParametersUUID, CreateSaveSettingsActionDescriptor( w, h, idShrpParameter ));
	app.playbackParameters = CreateSaveSettingsActionDescriptor( w, h, idShrpParameter );
}

// get the parameters values from an action descriptor and use them to fill the dialog
// return true if OK
function GetParameters( ad, dlg, wOld, hOld ) {
	var w, h, idEnumSharpness, sharpness;
	var retVal;
	
	var idW = charIDToTypeID( keyRMWidth );
	var idH = charIDToTypeID( keyRMHeight );
	var idShrp = charIDToTypeID( keyRMSharpness );

	retVal = true;

	if( ad.hasKey( idW ) )
		w = ad.getInteger( idW );
	else
		w = -1;

	if( ad.hasKey( idH ) )
		h = ad.getInteger( idH );
	else
		h = -1;

	if( ad.hasKey( idShrp ) )
		idEnumSharpness = ad.getEnumerationValue( idShrp );
	else
		retVal = false;

	if( retVal ) {
		dimensionFromParameters = "";
		// parameters have been retrieved, put them into the dialog
		if( w > 0 ) {
			dlg.pnlNewSize.txtWidth.text = w;
			dimensionFromParameters = "w";
			if( h < 0 )
				dlg.pnlNewSize.txtHeight.text = Math.round( w*hOld/wOld );
		}
		
		if( h > 0 ) {
			dlg.pnlNewSize.txtHeight.text = h;
			if( w < 0 )
				dlg.pnlNewSize.txtWidth.text = Math.round( h*wOld/hOld );
			if( dimensionFromParameters == "w" )
				dimensionFromParameters = "b";
			else
				dimensionFromParameters = "h";
		}

		sharpness = typeIDToCharID ( idEnumSharpness );
		if( sharpness == enumShrpSmoother )
			dlg.pnlImageQuality.optSmoother.value = true;
		if( sharpness == enumShrpNormal )
			dlg.pnlImageQuality.optNormal.value = true;
		if( sharpness == enumShrpSharper )
			dlg.pnlImageQuality.optSharper.value = true;
	}

	return retVal;
}


// --------------------------------------
// main code starts here
// it is embedded in a function to use suspendHistory() and get a single entry in the history palette
// --------------------------------------

function main() {
	
	var idEnumValue, rad, idEnumSharpness, idRegName, regName, idPluginVersion, pluginVersion;

	if( !CheckCurrentImage() ) {
		returnValue = 'cancel';	// no entry in the history palette
		return;
	}

	var startDisplayDialogs = app.displayDialogs;
	app.displayDialogs = DialogModes.NO;

	var docRef = app.activeDocument;
	// original size
	var wOld = docRef.width;
	var hOld = docRef.height;

	// look for the plugin
	var idPlugin = app.stringIDToTypeID( uniqueString);
	
	// --------------------------------------
	// get the registration name
	// --------------------------------------
	idEnumValue = charIDToTypeID( enumRMGetRegistrationName );
	rad = ExecuteCommand( idPlugin, idEnumValue );
	idRegName = charIDToTypeID( keyRegistrationName );
	regName = "";
	if( rad.hasKey(idRegName) ) {
		regName = rad.getString( idRegName );
	}

	// --------------------------------------
	// get the plugin version
	// --------------------------------------
	idEnumValue = charIDToTypeID( enumRMGetVersion );
	rad = ExecuteCommand( idPlugin, idEnumValue );
	idPluginVersion = charIDToTypeID( keyRMVersion );
	pluginVersion = "";
	if( rad.hasKey(idPluginVersion) ) {
		pluginVersion = rad.getString( idPluginVersion );
	}

	// check that versions match
	if( pluginVersion != scriptVersion ) {
		var msg = "The script and the plugin have different versions: Resize Magic might not work correctly.";
		msg += "\n\nReinstalling should solve the problem.";
		msg += "\n\nVersion of the script: " + scriptVersion;
		msg += "\nVersion of the plugin: " + pluginVersion;
		MsgErr( msg );
	}

	// create the main dialog
	var dlg = new Window( uiRM );

	dlg.text =	"Resize Magic V" + pluginVersion;
	dlg.stRegistrationName.text = regName;
	dlg.pnlOriginalSize.stOriginalWidth.text = wOld;
	dlg.pnlOriginalSize.stOriginalHeight.text = hOld;
	dlg.pnlImageQuality.optNormal.value = true;
	
	dlg.onShow = dlgMain_onShow;
	dlg.pnlNewSize.txtWidth.onChanging = txtWidth_onChanging;
	dlg.pnlNewSize.txtHeight.onChanging = txtHeight_onChanging;
	dlg.btnOK.onClick = btnOK_onClick;
	dlg.btnRegister.onClick = btnRegister_onClick;
	
	// get parameters
	try {
		var gotParams =  GetParameters( app.getCustomOptions(scriptParametersUUID), dlg, wOld, hOld );
	}
	catch( e ) {
		// just to catch possible errors
	}
	var inAction = GetParameters( app.playbackParameters, dlg, wOld, hOld );

	// if we are running in action without user interface do not show the dialog and read back the same values
	if( app.playbackDisplayDialogs == DialogModes.ALL ) {
		// show the main dialog to ask for the new size and other parameters
		var retVal = dlg.show();
		if( retVal != 1 ) {
			returnValue = 'cancel';	// no entry in the history palette
			return;
		}
	}

	var newWidth = Number( dlg.pnlNewSize.txtWidth.text );
	var newHeight = Number( dlg.pnlNewSize.txtHeight.text );
	// read the sharpness enum value
	var sharpness = enumShrpNormal;
	if( dlg.pnlImageQuality.optSmoother.value ) sharpness = enumShrpSmoother;
	if( dlg.pnlImageQuality.optSharper.value ) sharpness = enumShrpSharper;

	// --------------------------------------
	// execute the first step
	// --------------------------------------

	idEnumValue = charIDToTypeID( enumRMFirstStep );
	rad = ExecuteCommand( idPlugin, idEnumValue );

	// --------------------------------------
	// resize the image
	// --------------------------------------

	try	{
		docRef.resizeImage( newWidth, newHeight , docRef.resolution, ResampleMethod.NEARESTNEIGHBOR );
	}
	catch( e )  {
		returnValue = 'cancel';	// no entry in the history palette
		return;
	}

	// --------------------------------------
	// execute the second step
	// --------------------------------------

	idEnumValue = charIDToTypeID( enumRMSecondStep );
	idEnumSharpness = charIDToTypeID( sharpness );
	try	{
		rad = ExecuteCommandSetSharpness( idPlugin, idEnumValue, idEnumSharpness );
	}
	catch( e )  {
		if( e.message != "User cancelled the operation" ) {
			MsgErr( e.message );
		}
		returnValue = 'cancel';	// no entry in the history palette
		return;
	}

	// --------------------------------------
	// save the parameters values
	// --------------------------------------
	SaveParameters( newWidth, newHeight, idEnumSharpness, inAction );

//	var keyRes = GetResultStatus( rad );
//	alert( "q" + keyRes + "q" );


	app.displayDialogs = startDisplayDialogs;
	
}

// --------------------------------------
// execution starts here
// --------------------------------------

if( app.documents.length == 0 ) {
	MsgErr( "There is no image to resize" );
}
else {
	var savedState = app.activeDocument.activeHistoryState;
	var savedUnits = preferences.rulerUnits;
	preferences.rulerUnits = Units.PIXELS;

	app.activeDocument.suspendHistory( "Resize Magic", "main()" )

	if( returnValue == "cancel" ) {
		app.activeDocument.activeHistoryState = savedState;
	}

	preferences.rulerUnits = savedUnits;
}
